//********************************************************************
//  ConcentricCircles.java       Author: Lewis and Loftus
//
//  Solution to Programming Project 5.23 (5E, p. 288)
//********************************************************************

import javax.swing.JApplet;
import java.awt.*;

public class ConcentricCircles extends JApplet
{
   private final int NUM_CIRCLES = 10;
   private final int MIN_RADIUS = 5;
   private final int MAX_RADIUS = 140;
   private final int CENTER_X = 150;
   private final int CENTER_Y = 150;

   //-----------------------------------------------------------------
   //  Paints several concentric circles of random radius.
   //-----------------------------------------------------------------
   public void paint(Graphics page)
   {
      int radius, x, y;

      setBackground (Color.black);
      page.setColor (Color.green);

      for (int count=1; count <= NUM_CIRCLES; count++)
      {
         radius = (int) (Math.random() * MAX_RADIUS) + MIN_RADIUS;

         x = CENTER_X - radius;
         y = CENTER_Y - radius;

         page.drawOval (x, y, radius*2, radius*2);
      }
   }
}
